<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FieldValues extends Model 
{

    protected $table = 'lim_field_values';
    public $timestamps = true;
    protected $fillable = array('lim_field_id');
    protected $visible = array('lim_field_id');

    public function language()
    {
        return $this->hasOne('App\Models\FieldValueLanguage', 'lim_field_value_id')->where('lim_language_id', \Config::get('app.language_id'));
    }

    public function field()
    {
        return $this->belongsTo('App\Models\Fields', 'lim_field_id');
    }

    public function languages()
    {
        return $this->hasMany('App\Models\FieldValueLanguage', 'lim_field_value_id');
    }

}